local POUNDS_TO_KG = 0.453592


local rack_data =
{
    ["BRU_41"]          = {mass = 99.8, shapename = "mer_a4e", wstype = {4, 5, 32, WSTYPE_PLACEHOLDER} },
    ["BRU_42"]          = {mass = 47.6, shapename = "BRU_42A", wstype = {4, 5, 32, WSTYPE_PLACEHOLDER} },
}

--------------------------------- BOMBS ---------------------------------


bombs_data =
{
	["MK-82"]			= {name = "Mk-82",			mass = 241, wsType = {4, 5, 9, 31},  Cx = 0.00025, picture = "mk82.png"},
	["MK-82_Snakeye"]	= {name = "Mk-82 SnakeEye",	mass = 232, wsType = {4, 5, 9, 79},  Cx = 0.00035, picture = "mk82AIR.png"},
	["MK-82Y"]			= {name = "Mk-82Y",			mass = 232, wsType = MK_82Y.wsTypeOfWeapon,  Cx = 0.00035, picture = "mk82AIR.png"},
	["MK-82AIR"]		= {name = "Mk-82AIR",		mass = 232, wsType = {4, 5, 9, 75},  Cx = 0.00035, picture = "mk82AIR.png"},
	["ROCKEYE"]			= {name = "Mk-20 Rockeye",	mass = 222, wsType = {4, 5, 38, 45}, Cx = 0.000413, picture = "Mk20.png"},
	["GBU-12"] 			= {name = "GBU-12", 		mass = 275, wsType = {4, 5, 36, 38}, Cx = 0.000413, picture = "GBU12.png"},
	--["BL 755"]          = {name = "BL 755",         mass = 264, wstype = {4, 5,	38,	23},pic = 'BL755.png', count = 1 , cx = 0.001708984375,   tube = "BRU"},
	
}

local function MER_BRU_41A_Bombs_6bombs(element)
	local bomb_variant = bombs_data[element]
	
	local attach_point_position = element_self_attach_point[element]
	local data = {
		category		=	CAT_BOMBS,
		CLSID			=	"{BRU41_6X_"..element.."}",
		Picture			=	bomb_variant.picture,
		wsTypeOfWeapon	=	bomb_variant.wsType,
		displayName		=  _("BRU-41A - 6 x "..bomb_variant.name),
		attribute		=	{wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
		Cx_pil			=	bomb_variant.Cx,		-- TODO
		Count			=	6,
		Weight			=	90 + 6 * bomb_variant.mass,			--------------------------------------------- TODO
		Elements		= {	{ShapeName	= "BRU_41A",	IsAdapter  	   = true},
							{ShapeName	= element,		connector_name = "Point06" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point04" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point05" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point03" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point02" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point01" ,attach_point_position = attach_point_position }
		}, -- end of Elements
	}
	declare_loadout(data)
end

local function MER_BRU_41A_Bombs_4bombs(element)
	local bomb_variant = bombs_data[element]
	
	local attach_point_position = element_self_attach_point[element]
	local data = {
		category		=	CAT_BOMBS,
		CLSID			=	"{BRU41_4X_"..element.."}",
		Picture			=	bomb_variant.picture,
		wsTypeOfWeapon	=	bomb_variant.wsType,
		displayName		=  _("BRU-41A - 4 x "..bomb_variant.name),
		attribute		=	{wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
		Cx_pil			=	bomb_variant.Cx,		-- TODO
		Count			=	4,
		Weight			=	90 + 4 * bomb_variant.mass,			--------------------------------------------- TODO
		Elements		= {	{ShapeName	= "BRU_41A",	IsAdapter  	   = true},
							{ShapeName	= element,		connector_name = "Point06" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point04" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point05" ,attach_point_position = attach_point_position },
							{ShapeName	= element,		connector_name = "Point03" ,attach_point_position = attach_point_position }
		}, -- end of Elements
	}
	declare_loadout(data)
end








MER_BRU_41A_Bombs_6bombs("MK-82_Snakeye")
MER_BRU_41A_Bombs_4bombs("MK-82_Snakeye")

MER_BRU_41A_Bombs_6bombs("MK-82")
MER_BRU_41A_Bombs_4bombs("MK-82")

MER_BRU_41A_Bombs_6bombs("MK-82Y")
MER_BRU_41A_Bombs_4bombs("MK-82Y")

MER_BRU_41A_Bombs_6bombs("MK-82AIR")
MER_BRU_41A_Bombs_4bombs("MK-82AIR")

MER_BRU_41A_Bombs_6bombs("ROCKEYE")
MER_BRU_41A_Bombs_4bombs("ROCKEYE")

MER_BRU_41A_Bombs_4bombs("GBU-12")


---------------------------------------------------------------------- ROCKETS ------------------------------------------------------------------



local rocket_data = 
{
    ["LAU-3 FFAR WP156"]       = { name = "FFAR M156 WP", mass = 100 + 19 * (24.7 * POUNDS_TO_KG),  wstype = {4,7,33,147}, payload_CLSID = "{LAU3_FFAR_WP156}",                      shapename = "LAU-3",  pic = 'LAU61.png', count = 19, cx = 0.00146484375},
    ["LAU-3 FFAR Mk1 HE"]      = { name = "FFAR Mk1 HE",  mass = 100 + 19 * (21.5 * POUNDS_TO_KG),  wstype = {4,7,33,147}, payload_CLSID = "{LAU3_FFAR_MK1HE}",                      shapename = "LAU-3",  pic = 'LAU61.png', count = 19, cx = 0.00146484375},
    ["LAU-3 FFAR Mk5 HEAT"]    = { name = "FFAR Mk5 HEAT",mass = 100 + 19 * (21.6 * POUNDS_TO_KG),  wstype = {4,7,33,147}, payload_CLSID = "{LAU3_FFAR_MK5HEAT}",                    shapename = "LAU-3",  pic = 'LAU61.png', count = 19, cx = 0.00146484375},
    ["LAU-68 FFAR WP156"]      = { name = "FFAR M156 WP", mass = 41.73 + 7 * (24.7 * POUNDS_TO_KG), wstype = {4,7,33,147}, payload_CLSID = "{LAU68_FFAR_WP156}",                     shapename = "LAU-68", pic = 'LAU68.png', count = 7,  cx = 0.00146484375},
    ["LAU-68 FFAR Mk1 HE"]     = { name = "FFAR Mk1 HE",  mass = 41.73 + 7 * (21.5 * POUNDS_TO_KG), wstype = {4,7,33,147}, payload_CLSID = "{LAU68_FFAR_MK1HE}",                     shapename = "LAU-68", pic = 'LAU68.png', count = 7,  cx = 0.00146484375},
    ["LAU-68 FFAR Mk5 HEAT"]   = { name = "FFAR Mk5 HEAT",mass = 41.73 + 7 * (21.6 * POUNDS_TO_KG), wstype = {4,7,33,147}, payload_CLSID = "{LAU68_FFAR_MK5HEAT}",                   shapename = "LAU-68", pic = 'LAU68.png', count = 7,  cx = 0.00146484375},
    ["LAU-10 ZUNI"]            = { name = "ZUNI MK 71",   mass = 440,                               wstype = {4,7,33,37},  payload_CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", shapename = "LAU-10", pic = 'LAU10.png', count = 4,  cx = 0.001708984375},
	["S-13 OF"]                = { name = "S-13 OF",      mass = 510,                               wstype = {4,7,33,33},  payload_CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", shapename = "ub-13",  pic = 'rus_B-13L_S-13OF.png', count = 5,  cx = 0.00159912109375, tube = "B-13L"},
	["S-8 KOM"]                = { name = "S-8 KOM",      mass = 364,                               wstype = {4,7,33,32},  payload_CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", shapename = "B-20",   pic = 'rus_B-8M1_S-8KOM.png', count = 20, cx = 0.00146484375,    tube = "B-8M1"},
	["S-8 OFP2"]               = { name = "S-8 OFP2",     mass = 472,                               wstype = {4,7,33,155}, payload_CLSID = "B-8M1 - 20 S-8OFP2",                     shapename = "B-20",   pic = 'rus_B-8M1_S-8OFP2.png',count = 20, cx = 0.00213134765625, tube = "B-8M1"},
	["S-5 KO"]                 = { name = "S-5 KO",       mass = 275,                               wstype = {4,7,33,31},  payload_CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", shapename = "UB-32M1",pic = 'rus_UB-32_S-5KO.png',  count = 32, cx = 0.00196533203125, tube = "UB-32M1"},
	["LAU-61 Mk151 HE"]        = { name = "2.75' rockets MK151 HE", mass = 234,                     wstype = {4,7,33,145}, payload_CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", shapename = "LAU-61", pic = 'LAU61.png',            count = 19, cx = 0.001708984375,   tube = "LAU-61"},
	["LAU-131 Mk151 HE"]       = { name = "2.75' rockets MK151 HE", mass = 102.3,                   wstype = {4,7,33,147}, payload_CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}", shapename = "LAU-131",pic = 'LAU131.png',           count = 7 , cx = 0.00146484375,    tube = "LAU-131"},
	["LAU-3 Mk151 HE"]         = { name = "2.75' rockets MK151 HE", mass = 234,                     wstype = {4,7,33,147}, payload_CLSID = "LAU3_HE151",                             shapename = "LAU-3",  pic = 'LAU61.png',            count = 19 ,cx = 0.00146484375,    tube = "LAU-3"},
	["M70B HE"]                = { name = "ARAK M70B HE",           mass = 372.2,                   wstype = {4,7,33,wsType_ARAK70HE}, payload_CLSID = "{ARAKM70BHE}",               shapename = "ARAKM70B", pic = 'ARAK70HE.png',       count = 6 , cx = 0.00059912109375, tube = "ARAK M70B"},
	["LAU-131-MK5 HE"]         = { name = "2.75' rockets MK5 HE",   mass = 321.565,                 wstype = {4,7,33,145}, payload_CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}", shapename = "LAU-131",pic = 'LAU131.png',           count = 7 , cx = 0.00146484375,    tube = "LAU-131"},
	["LAU-3-MK5 HE"]           = { name = "2.75' rockets MK5 HEAT",   mass = 234,                   wstype = {4,7,33,145}, payload_CLSID = "LAU3_HE5",                               shapename = "LAU-3",  pic = 'LAU61.png',            count = 19 ,cx = 0.00146484375,    tube = "LAU-3"},
	["S-24B"]                  = { name = "S-24B",                  mass = 295,                     wstype = {4,7,33, 34}, payload_CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", shapename = "APU-7",  pic = 'RBK250.png',           count = 1 , cx = 0.001,            tube = "S-24B"},
	["S-25 OFM"]               = { name = "S-25 OFM",               mass = 495,                     wstype = {4,7,33, 35}, payload_CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", shapename = "C-25PU", pic = 'S25.png',              count = 1 , cx = 0.001708984375,   tube = "S-25 OFM"},
	
}

local function bru_42_lau(element, count, side, side_letter, Fpylon_mass)
    local lau_variant  = rocket_data[element] or rocket_data["LAU3_FFAR_MK1HE"]
    local rack_variant = rack_data["BRU_42"]
    local sidestr      = {"L","C","R"}
    local data         = {}

    data.category           = CAT_ROCKETS
    data.CLSID              = "{"..element.."_TER_"..tostring(count).."_"..side_letter.."}"
    data.attribute          = {4,	7,	32,	WSTYPE_PLACEHOLDER}
    data.Picture            = lau_variant.pic
    data.Count              = count * lau_variant.count
    data.displayName        = lau_variant.tube.." x "..tostring(count).." -- "..lau_variant.count*count.." - "..lau_variant.name 
    data.wsTypeOfWeapon     = lau_variant.wstype
    data.Weight             = rack_variant.mass + Fpylon_mass + count * lau_variant.mass
    data.Cx_pil             = lau_variant.cx*(count*.9)    
    data.Elements           =
    {
        {
            Position	=	{0,	0,	0},
            ShapeName	=	rack_variant.shapename,
            IsAdapter 	= 	true,
        },
    }

    local connectors   = {"Point03", "Point02", "Point01"}
    local rightorder2  = {2,1,3}
    local centerorder2 = {3,1,2}
    local leftorder2   = {1,2,3}

    -- for center, mount up to 3 ... if 2, do left and right
    -- for left, mount up to 2 skipping front right
    -- for right, mount up to 2 skipping front left
    
    local offset = 3-count
    local order = leftorder2 -- default, includes 3 bombs

    if count == 2 then
        if side == 0 then
            order = centerorder2
        elseif  side == 1 then
            order = rightorder2
        end
    end

    for i = 1,count do
        local j = order[i+offset]
        data.Elements[#data.Elements + 1] = {
                                                DrawArgs       = {{1,1},{2,1}},
                                                connector_name = connectors[j],
                                                payload_CLSID  = lau_variant.payload_CLSID,
                                                ShapeName      = lau_variant.shapename,
                                            }
    end

    return data
end



declare_loadout(bru_42_lau("S-13 OF", 2, 0, "C2", 52.0))    --  S-13 OF
declare_loadout(bru_42_lau("S-13 OF", 2, -1, "L", 45.0))    --  S-13 OF
declare_loadout(bru_42_lau("S-13 OF", 2, 1, "R", 45.0))     --  S-13 OF

declare_loadout(bru_42_lau("S-8 KOM", 3, 0, "C", 52.0))     --  S-8 KOM
declare_loadout(bru_42_lau("S-8 KOM", 2, 0, "C2", 52.0))    --  S-8 KOM
declare_loadout(bru_42_lau("S-8 KOM", 2, -1, "L", 45.0))    --  S-8 KOM
declare_loadout(bru_42_lau("S-8 KOM", 2, 1, "R", 45.0))     --  S-8 KOM

declare_loadout(bru_42_lau("S-8 OFP2", 3, 0, "C", 52.0))     --  S-8 OFP2
declare_loadout(bru_42_lau("S-8 OFP2", 2, 0, "C2", 52.0))    --  S-8 OFP2
declare_loadout(bru_42_lau("S-8 OFP2", 2, -1, "L", 45.0))    --  S-8 OFP2
declare_loadout(bru_42_lau("S-8 OFP2", 2, 1, "R", 45.0))     --  S-8 OFP2

declare_loadout(bru_42_lau("S-5 KO", 3, 0, "C", 52.0))     --  S-5 KO
declare_loadout(bru_42_lau("S-5 KO", 2, 0, "C2", 52.0))    --  S-5 KO
declare_loadout(bru_42_lau("S-5 KO", 2, -1, "L", 45.0))    --  S-5 KO
declare_loadout(bru_42_lau("S-5 KO", 2, 1, "R", 45.0))     --  S-5 KO

declare_loadout(bru_42_lau("LAU-61 Mk151 HE", 3, 0, "C", 52.0))     --  LAU-61 Mk151HE
declare_loadout(bru_42_lau("LAU-61 Mk151 HE", 2, 0, "C2", 52.0))    --  LAU-61 Mk151HE
declare_loadout(bru_42_lau("LAU-61 Mk151 HE", 2, -1, "L", 45.0))    --  LAU-61 Mk151HE
declare_loadout(bru_42_lau("LAU-61 Mk151 HE", 2, 1, "R", 45.0))     --  LAU-61 Mk151HE'

declare_loadout(bru_42_lau("LAU-131 Mk151 HE", 3, 0, "C", 52.0))     --  LAU-131 Mk151HE
declare_loadout(bru_42_lau("LAU-131 Mk151 HE", 2, 0, "C2", 52.0))    --  LAU-131 Mk151HE
declare_loadout(bru_42_lau("LAU-131 Mk151 HE", 2, -1, "L", 45.0))    --  LAU-131 Mk151HE
declare_loadout(bru_42_lau("LAU-131 Mk151 HE", 2, 1, "R", 45.0))     --  LAU-131 Mk151HE

--[[ Doesnt Work
declare_loadout(bru_42_lau("M70B HE", 3, 0, "C", 52.0))     --  M70B HE
declare_loadout(bru_42_lau("M70B HE", 2, 0, "C2", 52.0))    --  M70B HE
declare_loadout(bru_42_lau("M70B HE", 2, -1, "L", 45.0))    --  M70B HE
declare_loadout(bru_42_lau("M70B HE", 2, 1, "R", 45.0))     --  M70B HE
--]] 

declare_loadout(bru_42_lau("LAU-3 Mk151 HE", 3, 0, "C", 52.0))     --  LAU-3 Mk151 HE
declare_loadout(bru_42_lau("LAU-3 Mk151 HE", 2, 0, "C2", 52.0))    --  LAU-3 Mk151 HE
declare_loadout(bru_42_lau("LAU-3 Mk151 HE", 2, -1, "L", 45.0))    --  LAU-3 Mk151 HE
declare_loadout(bru_42_lau("LAU-3 Mk151 HE", 2, 1, "R", 45.0))     --  LAU-3 Mk151 HE

declare_loadout(bru_42_lau("LAU-131-MK5 HE", 3, 0, "C", 52.0))     --  LAU-131-MK5 HE
declare_loadout(bru_42_lau("LAU-131-MK5 HE", 2, 0, "C2", 52.0))    --  LAU-131-MK5 HE
declare_loadout(bru_42_lau("LAU-131-MK5 HE", 2, -1, "L", 45.0))    --  LAU-131-MK5 HE
declare_loadout(bru_42_lau("LAU-131-MK5 HE", 2, 1, "R", 45.0))     --  LAU-131-MK5 HE 

declare_loadout(bru_42_lau("LAU-3-MK5 HE", 3, 0, "C", 52.0))     --  LAU-3-MK5 HE
declare_loadout(bru_42_lau("LAU-3-MK5 HE", 2, 0, "C2", 52.0))    --  LAU-3-MK5 HE
declare_loadout(bru_42_lau("LAU-3-MK5 HE", 2, -1, "L", 45.0))    --  LAU-3-MK5 HE
declare_loadout(bru_42_lau("LAU-3-MK5 HE", 2, 1, "R", 45.0))     --  LAU-3-MK5 HE

declare_loadout(bru_42_lau("S-24B", 3, 0, "C", 52.0))     --  S-24B
declare_loadout(bru_42_lau("S-24B", 2, 0, "C2", 52.0))    --  S-24B
declare_loadout(bru_42_lau("S-24B", 2, -1, "L", 45.0))    --  S-24B
declare_loadout(bru_42_lau("S-24B", 2, 1, "R", 45.0))     --  S-24B

declare_loadout(bru_42_lau("S-25 OFM", 3, 0, "C", 52.0))     --  S-25 OFM
declare_loadout(bru_42_lau("S-25 OFM", 2, 0, "C2", 52.0))    --  S-25 OFM
declare_loadout(bru_42_lau("S-25 OFM", 2, -1, "L", 45.0))    --  S-25 OFM
declare_loadout(bru_42_lau("S-25 OFM", 2, 1, "R", 45.0))     --  S-25 OFM







